using UnityEngine;
using System.Collections;

public class s_Collider : MonoBehaviour
{
	public bool hitPlatform;
	public bool hitRepair;
	
	s_PlatformLife repairable;
	
	/*
	s_Player playerScript;
	
	void Start()
	{
		playerScript = (GameObject.Find("Player")).GetComponent<s_Player>();	
	}
	*/
	
	void OnTriggerExit(Collider other)
	{
		if (other.gameObject.tag == "Platform")
		{
			hitPlatform = false;
			hitRepair = false;
			repairable = null;
		}
	}
	
	void OnTriggerStay(Collider other)
	{
		if (other.gameObject.tag == "Platform")
			hitPlatform = true;
		
		//Check if you hit a repairable
		if (other.gameObject.name == "PlatformLily1" || other.gameObject.name == "PlatformLily2")
		{
			s_PlatformLife lifeScript = other.gameObject.GetComponent<s_PlatformLife>();
			if (lifeScript.health <= 0)
			{
				repairable = lifeScript;
				hitRepair = true;
			}
		}
	}
	
	public void Repair()
	{
		hitRepair = false;
		repairable.EnableSelf();
		repairable.health = 1;
		repairable.renderer.material.mainTexture = repairable.hp1;
	}
	
	public IEnumerator EnableCollider()
	{	
		collider.enabled = true;
		//playerScript.dontMove = true; //Moving is true because if you move while colliders are enabling, problems
		
	    transform.Translate(Vector3.up * 100);
		yield return new WaitForSeconds(0.025f);
		transform.Translate(Vector3.down * 100);
		//playerScript.dontMove = false;
	}
	
}
